/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jhotdraw.app.action.InsertNewConnectionAction;
import org.jhotdraw.draw.AtributoChaveFigure;
import org.jhotdraw.draw.AtributoChaveParcialFigure;
import org.jhotdraw.draw.AtributoDerivadoFigure;
import org.jhotdraw.draw.AtributoFigure;
import org.jhotdraw.draw.AtributoMultivaloradoFigure;
import org.jhotdraw.draw.ConnectionAttribute;
import org.jhotdraw.draw.DisjuncaoFigure;
import org.jhotdraw.draw.DoubleLineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.EntidadeFigure;
import org.jhotdraw.draw.EntidadeFracaFigure;
import org.jhotdraw.draw.EntidadeRelacionamentoFigure;
import org.jhotdraw.draw.GeneralizacaoLineConnectionFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledDoubleLineConnectionUmFigure;
import org.jhotdraw.draw.LabeledLineConnectionMuitosFigure;
import org.jhotdraw.draw.LabeledLineConnectionUmFigure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LineConnectionGeneralizacaoFigure;
import org.jhotdraw.draw.RelacionamentoFigure;
import org.jhotdraw.draw.RelacionamentoFracoFigure;
import org.jhotdraw.draw.SobreposicaoFigure;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.TextItalicoFigure;
import org.jhotdraw.draw.UniaoFigure;
import org.jhotdraw.draw.action.ModelValidationRules;
import org.jhotdraw.util.ResourceBundleUtil;

public class ConnectionRecommendationView
extends JFrame
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void desenhar(ArrayList<Class> connections, ArrayList<ModelValidationRules.ValidationRule> validRule, LineConnectionFigure lcf, Drawing draw) {
        JLabel text;
        String presentationName;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 1;
        cons.gridy = 0;
        cons.insets = new Insets(0, 5, 5, 5);
        cons.ipadx = 10;
        cons.anchor = 10;
        panel.add((Component)new JLabel(), cons);
        int i = 2;
        while (i <= 8) {
            cons = new GridBagConstraints();
            cons.gridx = i++;
            cons.gridy = 0;
            cons.insets = new Insets(0, 5, 5, 5);
            cons.ipadx = 40;
            cons.anchor = 10;
            panel.add((Component)new JLabel(), cons);
        }
        cons = new GridBagConstraints();
        cons.gridx = 9;
        cons.gridy = 0;
        cons.insets = new Insets(0, 5, 5, 5);
        cons.ipadx = 10;
        cons.anchor = 10;
        panel.add((Component)new JLabel(), cons);
        if (connections.size() == 0) {
            cons = new GridBagConstraints();
            cons.gridwidth = 8;
            cons.gridx = 1;
            cons.gridy = 1;
            cons.insets = new Insets(5, 5, 5, 5);
            cons.anchor = 10;
            String presentationName2 = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels").getString("recomendationConnectionsNo");
            JLabel text2 = new JLabel(presentationName2);
            panel.add((Component)text2, cons);
        } else {
            int metade = connections.size() / 2;
            int i2 = 1;
            cons = new GridBagConstraints();
            cons.gridwidth = 8;
            cons.gridx = 1;
            cons.gridy = i2;
            cons.insets = new Insets(5, 5, 5, 5);
            cons.anchor = 10;
            presentationName = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels").getString("recomendationConnections");
            text = new JLabel(presentationName);
            panel.add((Component)text, cons);
            for (Class clazz : connections) {
                if (i2 == metade || metade == -1 || metade == 0) {
                    cons = new GridBagConstraints();
                    cons.gridx = 2;
                    cons.gridy = i2 + 1;
                    cons.insets = new Insets(0, 5, 5, 5);
                    cons.anchor = 10;
                    panel.add((Component)new JLabel(this.getImageFigure(lcf.getStartFigure().getClass())), cons);
                }
                JButton btn = new JButton(this.getImageFigure(clazz));
                InsertNewConnectionAction nca = new InsertNewConnectionAction(lcf, clazz, draw);
                btn.addActionListener(nca);
                btn.addActionListener(this);
                cons = new GridBagConstraints();
                cons.gridx = 4;
                cons.gridy = i2 + 1;
                cons.insets = new Insets(0, 5, 5, 5);
                cons.anchor = 10;
                panel.add((Component)btn, cons);
                if (i2 == metade || metade == -1 || metade == 0) {
                    cons = new GridBagConstraints();
                    cons.gridx = 7;
                    cons.gridy = i2 + 1;
                    cons.insets = new Insets(0, 5, 5, 5);
                    cons.anchor = 10;
                    panel.add((Component)new JLabel(this.getImageFigure(lcf.getEndFigure().getClass())), cons);
                }
                ++i2;
            }
        }
        i = connections.size() + 2;
        int metade = this.numRows(validRule) / 2 + i - 1;
        cons = new GridBagConstraints();
        cons.gridwidth = 8;
        cons.gridx = 1;
        cons.gridy = i;
        cons.insets = new Insets(5, 5, 5, 5);
        cons.anchor = 10;
        presentationName = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels").getString("recomendationElements");
        text = new JLabel(presentationName);
        panel.add((Component)text, cons);
        for (ModelValidationRules.ValidationRule validationRule : validRule) {
            int j = 0;
            while (j < validationRule.getOrigem().length) {
                cons = new GridBagConstraints();
                cons.gridx = 2;
                cons.gridy = i + 1;
                cons.insets = new Insets(0, 5, 5, 5);
                cons.anchor = 10;
                panel.add((Component)new JLabel(this.getImageFigure(validationRule.getOrigem()[j])), cons);
                if (i == metade) {
                    cons = new GridBagConstraints();
                    cons.gridx = 4;
                    cons.gridy = i + 1;
                    cons.insets = new Insets(0, 5, 5, 5);
                    cons.anchor = 10;
                    panel.add((Component)new JLabel(this.getImageFigure(validationRule.getConexao())), cons);
                }
                int k = 0;
                while (k < validationRule.getDestino().length) {
                    cons = new GridBagConstraints();
                    cons.gridx = 6 + k;
                    cons.gridy = i + 1;
                    cons.insets = new Insets(0, 5, 5, 5);
                    cons.anchor = 10;
                    panel.add((Component)new JLabel(this.getImageFigure(validationRule.getDestino()[k])), cons);
                    ++k;
                }
                ++i;
                ++j;
            }
        }
        this.add(panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        this.setTitle(resourceBundleUtil.getString("recomendation"));
    }

    private int numRows(ArrayList<ModelValidationRules.ValidationRule> rules) {
        int sum = 0;
        for (ModelValidationRules.ValidationRule r : rules) {
            Class[] classArray = r.getOrigem();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                ++sum;
                ++n2;
            }
        }
        return sum;
    }

    private Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 2);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    private String getNameFigure(Class c) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        return labels.getTip(this.getLabelFigureName(c));
    }

    private ImageIcon getImageFigure(Class c) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        return new ImageIcon(this.getScaledImage(labels.getImageIconRecommendation(this.getLabelFigureName(c), c).getImage(), 40, 40));
    }

    public String getLabelFigureName(Class c) {
        if (c.equals(EntidadeFigure.class)) {
            return "createEntidade";
        }
        if (c.equals(EntidadeRelacionamentoFigure.class)) {
            return "createEntidadeRelacionamento";
        }
        if (c.equals(EntidadeFracaFigure.class)) {
            return "createEntidadeFraca";
        }
        if (c.equals(AtributoFigure.class)) {
            return "createAtributo";
        }
        if (c.equals(AtributoChaveFigure.class)) {
            return "createAtributoChave";
        }
        if (c.equals(AtributoChaveParcialFigure.class)) {
            return "createAtributoChaveParcial";
        }
        if (c.equals(AtributoMultivaloradoFigure.class)) {
            return "createAtributoMultivalorado";
        }
        if (c.equals(AtributoDerivadoFigure.class)) {
            return "createAtributoDerivado";
        }
        if (c.equals(RelacionamentoFigure.class)) {
            return "createRelacionamento";
        }
        if (c.equals(RelacionamentoFracoFigure.class)) {
            return "createRelacionamentoFraco";
        }
        if (c.equals(UniaoFigure.class)) {
            return "createUniao";
        }
        if (c.equals(SobreposicaoFigure.class)) {
            return "createSobreposicao";
        }
        if (c.equals(DisjuncaoFigure.class)) {
            return "createDisjuncao";
        }
        if (c.equals(ConnectionAttribute.class)) {
            return "createElbowConnectionAtributo";
        }
        if (c.equals(LabeledLineConnectionUmFigure.class)) {
            return "createElbowUmConnection";
        }
        if (c.equals(LabeledLineConnectionMuitosFigure.class)) {
            return "createElbowMuitosConnection";
        }
        if (c.equals(LabeledDoubleLineConnectionUmFigure.class)) {
            return "createElbowDoubleUmConnection";
        }
        if (c.equals(LabeledDoubleLineConnectionMuitosFigure.class)) {
            return "createElbowDoubleMuitosConnection";
        }
        if (c.equals(LineConnectionGeneralizacaoFigure.class)) {
            return "createElbowConnection";
        }
        if (c.equals(DoubleLineConnectionGeneralizacaoFigure.class)) {
            return "createElbowDoubleConnection";
        }
        if (c.equals(GeneralizacaoLineConnectionFigure.class)) {
            return "createGeneralizacaoConnection";
        }
        if (c.equals(TextItalicoFigure.class)) {
            return "createPapel";
        }
        if (c.equals(TextFigure.class)) {
            return "createText";
        }
        if (c.equals(TextAreaFigure.class)) {
            return "createAreaText";
        }
        return null;
    }
}

