/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.OptionPaneUI;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.Methods;

public class JSheet
extends JDialog {
    protected EventListenerList listenerList = new EventListenerList();
    private ComponentListener ownerMovementHandler;
    private Point shiftBackLocation;
    private Point oldLocation;
    private Component oldFocusOwner;
    private boolean isInstalled;
    private boolean isAnimated = true;
    private static final boolean isNativeSheet = System.getProperty("os.name").equals("Mac OS X") && System.getProperty("java.version").compareTo("1.6") >= 0;

    public JSheet(Frame owner) {
        super(owner);
        this.init();
    }

    public JSheet(Dialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        if (this.getOwner() != null && this.isShowAsSheet()) {
            if (JSheet.isNativeSheet()) {
                this.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
                Methods.invokeIfExistsWithEnum(this, "setModalityType", "java.awt.Dialog$ModalityType", "DOCUMENT_MODAL");
            } else {
                this.setUndecorated(true);
                this.getRootPane().setWindowDecorationStyle(0);
                this.getRootPane().setBorder(UIManager.getBorder("Sheet.border"));
            }
        }
        this.ownerMovementHandler = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                Window owner = JSheet.this.getOwner();
                Point newLocation = owner.getLocation();
                if (!newLocation.equals(JSheet.this.oldLocation)) {
                    JSheet.this.setLocation(newLocation.x + (owner.getWidth() - JSheet.this.getWidth()) / 2, newLocation.y + owner.getInsets().top);
                    JSheet.this.shiftBackLocation = null;
                    JSheet.this.oldLocation = newLocation;
                }
            }
        };
    }

    protected boolean isShowAsSheet() {
        return UIManager.getBoolean("Sheet.showAsSheet");
    }

    protected void installSheet() {
        if (!this.isInstalled) {
            Window owner = this.getOwner();
            if (owner != null) {
                Point sheetLoc;
                Point ownerLoc = owner.getLocation();
                if (this.isShowAsSheet()) {
                    sheetLoc = owner instanceof JFrame ? new Point(ownerLoc.x + (owner.getWidth() - this.getWidth()) / 2, ownerLoc.y + owner.getInsets().top + ((JFrame)owner).getRootPane().getContentPane().getY()) : (owner instanceof JDialog ? new Point(ownerLoc.x + (owner.getWidth() - this.getWidth()) / 2, ownerLoc.y + owner.getInsets().top + ((JDialog)owner).getRootPane().getContentPane().getY()) : new Point(ownerLoc.x + (owner.getWidth() - this.getWidth()) / 2, ownerLoc.y + owner.getInsets().top));
                    if (sheetLoc.x < 0) {
                        owner.setLocation(ownerLoc.x - sheetLoc.x, ownerLoc.y);
                        sheetLoc.x = 0;
                        this.shiftBackLocation = ownerLoc;
                        this.oldLocation = owner.getLocation();
                    } else {
                        this.shiftBackLocation = null;
                        this.oldLocation = ownerLoc;
                    }
                } else {
                    sheetLoc = new Point(ownerLoc.x + (owner.getWidth() - this.getWidth()) / 2, ownerLoc.y + (owner.getHeight() - this.getHeight()) / 2);
                }
                this.setLocation(sheetLoc);
                this.oldFocusOwner = owner.getFocusOwner();
                owner.setEnabled(false);
                if (UIManager.getBoolean("Sheet.showAsSheet")) {
                    owner.addComponentListener(this.ownerMovementHandler);
                } else if (owner instanceof Frame) {
                    this.setTitle(((Frame)owner).getTitle());
                }
            }
            this.isInstalled = true;
        }
    }

    protected void uninstallSheet() {
        if (this.isInstalled) {
            Window owner = this.getOwner();
            if (owner != null) {
                owner.setEnabled(true);
                owner.removeComponentListener(this.ownerMovementHandler);
                if (this.shiftBackLocation != null) {
                    owner.setLocation(this.shiftBackLocation);
                }
                if (this.oldFocusOwner != null) {
                    owner.toFront();
                    this.oldFocusOwner.requestFocus();
                }
            }
            this.isInstalled = false;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (UIManager.getBoolean("Sheet.showAsSheet")) {
            Methods.invokeStatic("ch.randelshofer.quaqua.QuaquaUtilities", "setWindowAlpha", new Class[]{Window.class, Integer.TYPE}, new Object[]{this, 240}, null);
        }
    }

    public void setAnimated(boolean newValue) {
        boolean oldValue = this.isAnimated;
        this.isAnimated = newValue;
        this.firePropertyChange("animated", oldValue, newValue);
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.uninstallSheet();
    }

    protected void hide0() {
        super.hide();
    }

    protected void show0() {
        super.show();
    }

    @Override
    public void hide() {
        if (this.isAnimated() && this.isShowAsSheet() && !JSheet.isNativeSheet()) {
            this.getContentPane().setVisible(false);
            final Rectangle startBounds = this.getBounds();
            int parentWidth = this.getParent().getWidth();
            final Rectangle endBounds = new Rectangle(parentWidth < startBounds.width ? startBounds.x + (startBounds.width - parentWidth) / 2 : startBounds.x, startBounds.y, Math.min(startBounds.width, parentWidth), 0);
            final Timer timer = new Timer(20, null);
            timer.addActionListener(new ActionListener(){
                long startTime;
                long endTime;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    long now = System.currentTimeMillis();
                    if (this.startTime == 0L) {
                        this.startTime = now;
                        this.endTime = this.startTime + 200L;
                    }
                    if (now > this.endTime) {
                        timer.stop();
                        JSheet.this.hide0();
                        JSheet.this.setBounds(startBounds);
                        JSheet.this.getContentPane().setVisible(true);
                        JSheet.this.uninstallSheet();
                    } else {
                        float ratio = (float)(now - this.startTime) / (float)(this.endTime - this.startTime);
                        JSheet.this.setBounds((int)((float)startBounds.x * (1.0f - ratio) + (float)endBounds.x * ratio), (int)((float)startBounds.y * (1.0f - ratio) + (float)endBounds.y * ratio), (int)((float)startBounds.width * (1.0f - ratio) + (float)endBounds.width * ratio), (int)((float)startBounds.height * (1.0f - ratio) + (float)endBounds.height * ratio));
                    }
                }
            });
            timer.setRepeats(true);
            timer.setInitialDelay(5);
            timer.start();
        } else {
            this.hide0();
            this.uninstallSheet();
        }
    }

    @Override
    public void show() {
        if (this.isAnimated() && this.isShowAsSheet() && !JSheet.isNativeSheet()) {
            this.installSheet();
            this.getContentPane().setVisible(false);
            long startTime = System.currentTimeMillis();
            long endTime = startTime + 300L;
            final Rectangle endBounds = this.getBounds();
            int parentWidth = this.getParent().getWidth();
            final Rectangle startBounds = new Rectangle(parentWidth < endBounds.width ? endBounds.x + (endBounds.width - parentWidth) / 2 : endBounds.x, endBounds.y, Math.min(endBounds.width, parentWidth), 0);
            this.setBounds(startBounds);
            this.show0();
            final Timer timer = new Timer(20, null);
            timer.addActionListener(new ActionListener(){
                long startTime;
                long endTime;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    long now = System.currentTimeMillis();
                    if (this.startTime == 0L) {
                        this.startTime = now;
                        this.endTime = this.startTime + 200L;
                    }
                    if (now > this.endTime) {
                        timer.stop();
                        JSheet.this.setBounds(endBounds);
                        JSheet.this.getContentPane().setVisible(true);
                        JSheet.this.requestFocus();
                        ((Window)JSheet.this.getParent()).toFront();
                    } else {
                        float ratio = (float)(now - this.startTime) / (float)(this.endTime - this.startTime);
                        JSheet.this.setBounds((int)((float)startBounds.x * (1.0f - ratio) + (float)endBounds.x * ratio), (int)((float)startBounds.y * (1.0f - ratio) + (float)endBounds.y * ratio), (int)((float)startBounds.width * (1.0f - ratio) + (float)endBounds.width * ratio), (int)((float)startBounds.height * (1.0f - ratio) + (float)endBounds.height * ratio));
                    }
                }
            });
            timer.setRepeats(true);
            timer.setInitialDelay(5);
            timer.start();
        } else {
            this.installSheet();
            this.show0();
        }
        JSheet.requestUserAttention();
    }

    public static void requestUserAttention() {
    }

    public void addSheetListener(SheetListener l) {
        this.listenerList.add(SheetListener.class, l);
    }

    public void removeSheetListener(SheetListener l) {
        this.listenerList.remove(SheetListener.class, l);
    }

    protected void fireOptionSelected(JOptionPane pane) {
        int option;
        Object value = pane.getValue();
        if (value == null) {
            option = -1;
        } else if (pane.getOptions() == null) {
            option = value instanceof Integer ? (Integer)value : -1;
        } else {
            option = -1;
            Object[] options = pane.getOptions();
            int i = 0;
            int n = options.length;
            while (i < n) {
                if (options[i].equals(value)) {
                    option = i;
                    break;
                }
                ++i;
            }
            if (option == -1) {
                value = null;
            }
        }
        this.fireOptionSelected(pane, option, value, pane.getInputValue());
    }

    protected void fireOptionSelected(JOptionPane pane, int option, Object value, Object inputValue) {
        SheetEvent sheetEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == SheetListener.class) {
                if (sheetEvent == null) {
                    sheetEvent = new SheetEvent(this, pane, option, value, inputValue);
                }
                ((SheetListener)listeners[i + 1]).optionSelected(sheetEvent);
            }
            i -= 2;
        }
    }

    protected void fireOptionSelected(JFileChooser pane, int option) {
        SheetEvent sheetEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == SheetListener.class) {
                if (sheetEvent == null) {
                    sheetEvent = new SheetEvent(this, pane, option, null);
                }
                ((SheetListener)listeners[i + 1]).optionSelected(sheetEvent);
            }
            i -= 2;
        }
    }

    public static void showSheet(JOptionPane pane, Component parentComponent, SheetListener listener) {
        JSheet sheet = JSheet.createSheet(pane, parentComponent, JSheet.styleFromMessageType(pane.getMessageType()));
        sheet.addSheetListener(listener);
        sheet.show();
    }

    public static void showConfirmSheet(Component parentComponent, Object message, SheetListener listener) {
        JSheet.showConfirmSheet(parentComponent, message, 1, listener);
    }

    public static void showConfirmSheet(Component parentComponent, Object message, int optionType, SheetListener listener) {
        JSheet.showConfirmSheet(parentComponent, message, optionType, 3, listener);
    }

    public static void showConfirmSheet(Component parentComponent, Object message, int optionType, int messageType, SheetListener listener) {
        JSheet.showConfirmSheet(parentComponent, message, optionType, messageType, null, listener);
    }

    public static void showConfirmSheet(Component parentComponent, Object message, int optionType, int messageType, Icon icon, SheetListener listener) {
        JSheet.showOptionSheet(parentComponent, message, optionType, messageType, icon, null, null, listener);
    }

    public static void showInputSheet(Component parentComponent, Object message, SheetListener listener) {
        JSheet.showInputSheet(parentComponent, message, 3, listener);
    }

    public static void showInputSheet(Component parentComponent, Object message, Object initialSelectionValue, SheetListener listener) {
        JSheet.showInputSheet(parentComponent, message, 3, null, null, initialSelectionValue, listener);
    }

    public static void showInputSheet(Component parentComponent, Object message, int messageType, SheetListener listener) {
        JSheet.showInputSheet(parentComponent, message, messageType, null, null, null, listener);
    }

    public static void showInputSheet(Component parentComponent, Object message, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue, SheetListener listener) {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = JSheet.styleFromMessageType(messageType);
        JSheet sheet = JSheet.createSheet(pane, parentComponent, style);
        pane.selectInitialValue();
        sheet.addSheetListener(listener);
        sheet.show();
        sheet.toFront();
    }

    public static void showMessageSheet(Component parentComponent, Object message) {
        JSheet.showMessageSheet(parentComponent, message, 1);
    }

    public static void showMessageSheet(Component parentComponent, Object message, SheetListener listener) {
        JSheet.showMessageSheet(parentComponent, message, 1, listener);
    }

    public static void showMessageSheet(Component parentComponent, Object message, int messageType) {
        JSheet.showMessageSheet(parentComponent, message, messageType, null, null);
    }

    public static void showMessageSheet(Component parentComponent, Object message, int messageType, SheetListener listener) {
        JSheet.showMessageSheet(parentComponent, message, messageType, null, listener);
    }

    public static void showMessageSheet(Component parentComponent, Object message, int messageType, Icon icon, SheetListener listener) {
        JSheet.showOptionSheet(parentComponent, message, -1, messageType, icon, null, null, listener);
    }

    public static void showOptionSheet(Component parentComponent, Object message, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, SheetListener listener) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = JSheet.styleFromMessageType(messageType);
        JSheet sheet = JSheet.createSheet(pane, parentComponent, style);
        pane.selectInitialValue();
        sheet.addSheetListener(listener);
        sheet.show();
        sheet.toFront();
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private static JSheet createSheet(final JOptionPane pane, Component parentComponent, int style) {
        Window window = JSheet.getWindowForComponent(parentComponent);
        final JSheet sheet = window instanceof Frame ? new JSheet((Frame)window) : new JSheet((Dialog)window);
        JComponent contentPane = (JComponent)sheet.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (JSheet.isNativeSheet()) {
            contentPane.setBorder(new EmptyBorder(12, 0, 0, 0));
        }
        contentPane.add((Component)pane, "Center");
        sheet.setResizable(false);
        sheet.addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;
            int count;

            @Override
            public void windowClosing(WindowEvent we) {
                pane.setValue(null);
            }

            @Override
            public void windowClosed(WindowEvent we) {
                if (pane.getValue() == JOptionPane.UNINITIALIZED_VALUE) {
                    sheet.fireOptionSelected(pane);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    OptionPaneUI ui = pane.getUI();
                    if (ui != null) {
                        ui.selectInitialValue(pane);
                    }
                    this.gotFocus = true;
                }
            }
        });
        sheet.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (sheet.isVisible() && event.getSource() == pane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    sheet.setVisible(false);
                    sheet.fireOptionSelected(pane);
                }
            }
        });
        sheet.pack();
        return sheet;
    }

    static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return JSheet.getWindowForComponent(parentComponent.getParent());
    }

    public static void showSaveSheet(JFileChooser chooser, Component parent, SheetListener listener) {
        chooser.setDialogType(1);
        JSheet.showSheet(chooser, parent, null, listener);
    }

    public static void showOpenSheet(JFileChooser chooser, Component parent, SheetListener listener) {
        chooser.setDialogType(0);
        JSheet.showSheet(chooser, parent, null, listener);
    }

    public static void showSheet(final JFileChooser chooser, Component parent, String approveButtonText, SheetListener listener) {
        if (approveButtonText != null) {
            chooser.setApproveButtonText(approveButtonText);
            chooser.setDialogType(2);
        }
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        String title = chooser.getUI().getDialogTitle(chooser);
        chooser.getAccessibleContext().setAccessibleDescription(title);
        final JSheet sheet = new JSheet(frame);
        sheet.addSheetListener(listener);
        Container contentPane = sheet.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser, "Center");
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int option = evt.getActionCommand().equals("ApproveSelection") ? 0 : 1;
                sheet.hide();
                sheet.fireOptionSelected(chooser, option);
                chooser.removeActionListener(this);
            }
        };
        chooser.addActionListener(actionListener);
        sheet.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                sheet.fireOptionSelected(chooser, 1);
                chooser.removeActionListener(actionListener);
            }
        });
        chooser.rescanCurrentDirectory();
        sheet.pack();
        sheet.show();
        sheet.toFront();
    }

    private static boolean isNativeSheet() {
        return isNativeSheet;
    }
}

