/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.io;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private String description;
    private HashSet<String> extensions;
    private String defaultExtension;

    public ExtensionFileFilter(String description, String extension) {
        this.description = description;
        this.extensions = new HashSet();
        this.extensions.add(extension.toLowerCase());
        this.defaultExtension = extension;
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        this.description = description;
        this.extensions = new HashSet();
        String[] extlc = new String[extensions.length];
        int i = 0;
        while (i < extlc.length) {
            extlc[i] = extensions[i].toLowerCase();
            ++i;
        }
        this.extensions.addAll(Arrays.asList(extlc));
        this.defaultExtension = extensions[0];
    }

    public Set<String> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        String name = pathname.getName();
        int p = name.lastIndexOf(46);
        if (p == -1 || p == name.length() - 1) {
            return this.extensions.contains("");
        }
        return this.extensions.contains(name.substring(p + 1).toLowerCase());
    }

    public File makeAcceptable(File pathname) {
        if (this.accept(pathname)) {
            return pathname;
        }
        return new File(String.valueOf(pathname.getPath()) + '.' + this.defaultExtension);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

