/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.undo;

import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.undo.UndoRedoManager;

public class CompositeEdit
extends CompoundEdit {
    private String presentationName;
    private boolean isSignificant;
    private boolean isVerbose;

    public void setVerbose(boolean b) {
        this.isVerbose = b;
    }

    public CompositeEdit() {
        this.isSignificant = true;
    }

    public CompositeEdit(boolean isSignificant) {
        this.isSignificant = isSignificant;
    }

    public CompositeEdit(String presentationName) {
        this.presentationName = presentationName;
        this.isSignificant = true;
    }

    public CompositeEdit(String presentationName, boolean isSignificant) {
        this.presentationName = presentationName;
        this.isSignificant = isSignificant;
    }

    @Override
    public String getPresentationName() {
        return this.presentationName != null ? this.presentationName : super.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        return this.presentationName != null ? String.valueOf(UndoRedoManager.getLabels().getString("undo")) + " " + this.presentationName : super.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return this.presentationName != null ? String.valueOf(UndoRedoManager.getLabels().getString("redo")) + " " + this.presentationName : super.getRedoPresentationName();
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit == this) {
            this.end();
            return true;
        }
        if (this.isInProgress() && anEdit instanceof CompositeEdit) {
            return true;
        }
        return super.addEdit(anEdit);
    }

    @Override
    public boolean isSignificant() {
        return this.isSignificant ? super.isSignificant() : false;
    }

    public void setSignificant(boolean newValue) {
        this.isSignificant = newValue;
    }
}

