/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jhotdraw.util.LocaleUtil;

public class ResourceBundleUtil {
    private ResourceBundle resource;
    private Class baseClass = this.getClass();

    public ResourceBundleUtil(ResourceBundle r) {
        this.resource = r;
    }

    public ResourceBundle getBundle() {
        return this.resource;
    }

    public String getString(String key) {
        try {
            return this.resource.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public Integer getInteger(String key) {
        try {
            return Integer.valueOf(this.resource.getString(key));
        }
        catch (MissingResourceException e) {
            return new Integer(-1);
        }
    }

    public ImageIcon getImageIconRecommendation(String key, Class baseClass) {
        URL url;
        String rsrcName;
        block7: {
            try {
                rsrcName = this.resource.getString(String.valueOf(key) + ".icon2");
                if (!rsrcName.equals("")) break block7;
                return null;
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        if (!rsrcName.startsWith("/")) {
            String imageDir;
            try {
                imageDir = this.resource.getString("$imageDir");
                if (!imageDir.endsWith("/")) {
                    imageDir = String.valueOf(imageDir) + "/";
                }
            }
            catch (MissingResourceException e) {
                imageDir = "";
            }
            rsrcName = String.valueOf(imageDir) + rsrcName;
        }
        return (url = baseClass.getResource(rsrcName)) == null ? null : new ImageIcon(url);
    }

    public ImageIcon getImageIcon(String key, Class baseClass) {
        URL url;
        String rsrcName;
        block7: {
            try {
                rsrcName = this.resource.getString(String.valueOf(key) + ".icon");
                if (!rsrcName.equals("")) break block7;
                return null;
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        if (!rsrcName.startsWith("/")) {
            String imageDir;
            try {
                imageDir = this.resource.getString("$imageDir");
                if (!imageDir.endsWith("/")) {
                    imageDir = String.valueOf(imageDir) + "/";
                }
            }
            catch (MissingResourceException e) {
                imageDir = "";
            }
            rsrcName = String.valueOf(imageDir) + rsrcName;
        }
        return (url = baseClass.getResource(rsrcName)) == null ? null : new ImageIcon(url);
    }

    public char getMnemonic(String key) {
        String s = this.resource.getString(key);
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(0);
    }

    public char getMnem(String key) {
        String s;
        try {
            s = this.resource.getString(String.valueOf(key) + ".mnem");
        }
        catch (MissingResourceException e) {
            s = null;
        }
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(0);
    }

    public String getTip(String key) {
        try {
            return this.resource.getString(String.valueOf(key) + ".tip");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public KeyStroke getKeyStroke(String key) {
        KeyStroke ks = null;
        try {
            String s = this.resource.getString(key);
            ks = s == null ? null : KeyStroke.getKeyStroke(s);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ks;
    }

    public KeyStroke getAcc(String key) {
        KeyStroke ks = null;
        try {
            String s = this.resource.getString(String.valueOf(key) + ".acc");
            ks = s == null ? null : KeyStroke.getKeyStroke(s);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ks;
    }

    public String getFormatted(String key, String argument) {
        return MessageFormat.format(this.resource.getString(key), argument);
    }

    public String getFormatted(String key, Object ... arguments) {
        return MessageFormat.format(this.resource.getString(key), arguments);
    }

    public static ResourceBundleUtil getLAFBundle(String baseName) throws MissingResourceException {
        return ResourceBundleUtil.getLAFBundle(baseName, LocaleUtil.getDefault());
    }

    public void setBaseClass(Class baseClass) {
        this.baseClass = baseClass;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public void configureAction(Action action, String argument) {
        this.configureAction(action, argument, this.getBaseClass());
    }

    public void configureAction(Action action, String argument, Class baseClass) {
        action.putValue("Name", this.getString(argument));
        action.putValue("AcceleratorKey", this.getAcc(argument));
        action.putValue("MnemonicKey", new Integer(this.getMnem(argument)));
        action.putValue("SmallIcon", this.getImageIcon(argument, baseClass));
    }

    public void configureButton(AbstractButton button, String argument) {
        this.configureButton(button, argument, this.getBaseClass());
    }

    public void configureButton(AbstractButton button, String argument, Class baseClass) {
        button.setText(this.getString(argument));
        button.setIcon(this.getImageIcon(argument, baseClass));
        button.setToolTipText(this.getTip(argument));
    }

    public void configureToolBarButton(AbstractButton button, String argument) {
        this.configureToolBarButton(button, argument, this.getBaseClass());
    }

    public void configureToolBarButton(AbstractButton button, String argument, Class baseClass) {
        ImageIcon icon = this.getImageIcon(argument, baseClass);
        if (icon != null) {
            button.setIcon(this.getImageIcon(argument, baseClass));
            button.setText(null);
        } else {
            button.setIcon(null);
            button.setText(this.getString(argument));
        }
        button.setToolTipText(this.getTip(argument));
    }

    public void configureMenu(JMenuItem menu, String argument) {
        menu.setText(this.getString(argument));
        if (!(menu instanceof JMenu)) {
            menu.setAccelerator(this.getAcc(argument));
        }
        menu.setMnemonic(this.getMnem(argument));
        menu.setIcon(this.getImageIcon(argument, this.baseClass));
    }

    public JMenuItem createMenuItem(Action a, String baseName) {
        JMenuItem mi = new JMenuItem();
        mi.setAction(a);
        this.configureMenu(mi, baseName);
        return mi;
    }

    public static ResourceBundleUtil getLAFBundle(String baseName, Locale locale) throws MissingResourceException {
        ResourceBundleUtil r;
        try {
            r = new ResourceBundleUtil(ResourceBundle.getBundle(String.valueOf(baseName) + '_' + UIManager.getLookAndFeel().getID(), locale));
        }
        catch (MissingResourceException e) {
            try {
                r = new ResourceBundleUtil(ResourceBundle.getBundle(baseName, locale));
            }
            catch (MissingResourceException e2) {
                r = new ResourceBundleUtil(ResourceBundle.getBundle(baseName, Locale.ENGLISH));
            }
        }
        return r;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.resource + "]";
    }
}

