/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util.prefs;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.prefs.Preferences;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicToolBarUI;

public class ToolBarPrefsHandler
implements ComponentListener,
AncestorListener {
    private JToolBar toolbar;
    private String prefsPrefix;
    private Preferences prefs;
    private boolean firstTimeShown;

    public ToolBarPrefsHandler(JToolBar toolbar, String prefsPrefix, Preferences prefs) {
        this.toolbar = toolbar;
        this.prefsPrefix = prefsPrefix;
        this.prefs = prefs;
        String constraint = prefs.get(String.valueOf(prefsPrefix) + ".constraint", "North");
        int orientation = constraint.equals("North") || constraint.equals("South") ? 0 : 1;
        toolbar.setOrientation(orientation);
        toolbar.getParent().add(constraint, toolbar);
        toolbar.setVisible(prefs.getBoolean(String.valueOf(prefsPrefix) + ".visible", true));
        toolbar.addComponentListener(this);
        toolbar.addAncestorListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.prefs.putBoolean(String.valueOf(this.prefsPrefix) + ".visible", false);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.locationChanged();
    }

    private void locationChanged() {
        if (this.toolbar.getUI() instanceof BasicToolBarUI) {
            BasicToolBarUI ui = (BasicToolBarUI)this.toolbar.getUI();
            boolean floating = ui.isFloating();
            this.prefs.putBoolean(String.valueOf(this.prefsPrefix) + ".isFloating", floating);
            if (floating) {
                Window window = SwingUtilities.getWindowAncestor(this.toolbar);
                this.prefs.putInt(String.valueOf(this.prefsPrefix) + ".floatingX", window.getX());
                this.prefs.putInt(String.valueOf(this.prefsPrefix) + ".floatingY", window.getY());
            } else if (this.toolbar.getParent() != null) {
                int x = this.toolbar.getX();
                int y = this.toolbar.getY();
                Insets insets = this.toolbar.getParent().getInsets();
                String constraint = x == insets.left && y == insets.top ? (this.toolbar.getOrientation() == 0 ? "North" : "West") : (this.toolbar.getOrientation() == 0 ? "South" : "East");
                this.prefs.put(String.valueOf(this.prefsPrefix) + ".constraint", constraint);
            }
        } else if (this.toolbar.getParent() != null) {
            int x = this.toolbar.getX();
            int y = this.toolbar.getY();
            Insets insets = this.toolbar.getParent().getInsets();
            String constraint = x == insets.left && y == insets.top ? (this.toolbar.getOrientation() == 0 ? "North" : "West") : (this.toolbar.getOrientation() == 0 ? "South" : "East");
            this.prefs.put(String.valueOf(this.prefsPrefix) + ".constraint", constraint);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.locationChanged();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.prefs.putBoolean(String.valueOf(this.prefsPrefix) + ".visible", true);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.locationChanged();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (this.toolbar.getUI() instanceof BasicToolBarUI && ((BasicToolBarUI)this.toolbar.getUI()).isFloating()) {
            this.locationChanged();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (this.toolbar.getUI() instanceof BasicToolBarUI && ((BasicToolBarUI)this.toolbar.getUI()).isFloating()) {
            this.locationChanged();
        }
    }
}

